<?php

namespace BESTSELLER;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Depreciation extends Model 
{

    protected $table = 'DepreciationData';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('CostCenter', 'Month', 'Year', 'Value');
    protected $visible = array('CostCenter', 'Month', 'Year', 'Value');

    public function Store()
    {
        return $this->belongsTo('BESTSELLER\StoreData', 'CostCenter', 'CostCenter');
    }

}