<?php

namespace BESTSELLER;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StoreStaff extends Model 
{

    protected $table = 'StoreStaff';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('LODASNo', 'Firstname', 'Lastname', 'StartDate', 'EndDate');
    protected $visible = array('LODASNo', 'Firstname', 'Lastname', 'StartDate', 'EndDate');

    public function MonthlyData()
    {
        return $this->hasMany('BESTSELLER\StoreStaffMonth', 'id', 'StaffID');
    }

    public function Absence()
    {
        return $this->hasMany('BESTSELLER\StoreStaffAbsence', 'StaffID');
    }

}