<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAllpatientsTable extends Migration {

	public function up()
	{
		Schema::create('allpatients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('trust_code')->nullable();
			$table->string('region_code')->nullable();
			$table->string('data_type');
			$table->string('clinical_nurse_spec');
			$table->string('path_curative');
			$table->string('path_non_curative');
			$table->string('path_tlc');
			$table->string('path_other');
			$table->string('timespan');
			$table->smallInteger('num');
		});
	}

	public function down()
	{
		Schema::drop('allpatients');
	}
}