<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTrustsTable extends Migration {

	public function up()
	{
		Schema::create('trusts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('trust_code')->unique();
			$table->string('region_code')->index();
			$table->string('trust_name');
			$table->string('trust_slug');
			$table->string('trust_body')->nullable();
			$table->string('trust_info')->nullable();
			$table->boolean('colorectal_oncall');
			$table->boolean('bowel_stenting');
			$table->boolean('onsite_mri');
			$table->boolean('onsite_pet_ct');
			$table->boolean('onsite_cpet');
			$table->boolean('onsite_chemo');
			$table->boolean('onsite_radio');
			$table->boolean('onsite_hepat');
			$table->boolean('onsite_thora');
			$table->boolean('dedi_eras');
			$table->boolean('palli_care');
		});
	}

	public function down()
	{
		Schema::drop('trusts');
	}
}