<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMajorresectionTable extends Migration {

	public function up()
	{
		Schema::create('majorresection', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('trust_code')->nullable();
			$table->string('region_code')->nullable();
			$table->string('data_type');
			$table->string('distant_metastases');
			$table->string('urgent_surgery');
			$table->string('median_excised');
			$table->string('lapa_surgery');
			$table->string('length_of_stay');
			$table->string('timespan');
			$table->smallInteger('num')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('majorresection');
	}
}