<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;
    protected $fillable = array('main_image', 'quantity', 'code', 'video', 'release_date', 'developers', 'publishers', 'works_on_id', 'platform_id', 'region_id');

    public function translations()
    {
        return $this->hasMany('Models\ProductTranslation', 'product_id');
    }

}