<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCardPaymentTable extends Migration {

	public function up()
	{
		Schema::create('card_payment', function(Blueprint $table) {
			$table->increments('id_card_payment');
			$table->integer('id_transaction');
			$table->string('account', 100);
			$table->string('card_number', 255);
			$table->integer('plan')->nullable();
			$table->integer('sequence');
			$table->tinyInteger('terminal');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
			$table->float('amount');
			$table->integer('conciliation_status');
		});
	}

	public function down()
	{
		Schema::drop('card_payment');
	}
}