<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'd_o_b', 'last_donation_date', 'city_id', 'phone', 'password');

	public function posts()
	{
		return $this->morphedByMany('App\Models\Post', 'clientable');
	}

	public function notifications()
	{
		return $this->morphedByMany('App\Models\Notification', 'clientable');
	}

	public function bloodTypes()
	{
		return $this->morphedByMany('App\Models\BloodType', 'clientable');
	}

	public function governments()
	{
		return $this->morphedByMany('App\Models\Government', 'clientable');
	}

	public function cities()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function donationRequests()
	{
		return $this->hasMany('App\Models\DonationRequest');
	}

}