<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Discussion extends Eloquent {

	protected $table = 'discussions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function group()
	{
		return $this->belongsTo('Group');
	}

	public function parent()
	{
		return $this->hasOne('Discussion', 'parent_id');
	}

	public function votes()
	{
		return $this->morphMany('Vote', 'votable');
	}

}