<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Group extends Eloquent {

	protected $table = 'groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function users()
	{
		return $this->hasMany('User');
	}

	public function actions()
	{
		return $this->hasMany('Group');
	}

	public function discussions()
	{
		return $this->hasMany('Group');
	}

	public function files()
	{
		return $this->hasMany('File');
	}

}