<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tasas', function(Blueprint $table) {
			$table->foreign('paneles_id')->references('id')->on('paneles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('informacion_tasa', function(Blueprint $table) {
			$table->foreign('tasas_id')->references('id')->on('tasas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('informacion_tasa', function(Blueprint $table) {
			$table->foreign('tipo_informacion_tasa_id')->references('id')->on('tipo_informacion_tasa')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('informacion_comparativa', function(Blueprint $table) {
			$table->foreign('paneles_id')->references('id')->on('paneles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('gastos', function(Blueprint $table) {
			$table->foreign('paneles_id')->references('id')->on('paneles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Informacion_gasto', function(Blueprint $table) {
			$table->foreign('gastos_id')->references('id')->on('gastos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Informacion_gasto', function(Blueprint $table) {
			$table->foreign('tipo_informacion_gasto_id')->references('id')->on('tipo_informacion_gasto')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('tasas', function(Blueprint $table) {
			$table->dropForeign('tasas_paneles_id_foreign');
		});
		Schema::table('informacion_tasa', function(Blueprint $table) {
			$table->dropForeign('informacion_tasa_tasas_id_foreign');
		});
		Schema::table('informacion_tasa', function(Blueprint $table) {
			$table->dropForeign('informacion_tasa_tipo_informacion_tasa_id_foreign');
		});
		Schema::table('informacion_comparativa', function(Blueprint $table) {
			$table->dropForeign('informacion_comparativa_paneles_id_foreign');
		});
		Schema::table('gastos', function(Blueprint $table) {
			$table->dropForeign('gastos_paneles_id_foreign');
		});
		Schema::table('Informacion_gasto', function(Blueprint $table) {
			$table->dropForeign('Informacion_gasto_gastos_id_foreign');
		});
		Schema::table('Informacion_gasto', function(Blueprint $table) {
			$table->dropForeign('Informacion_gasto_tipo_informacion_gasto_id_foreign');
		});
	}
}