<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLinkTable extends Migration {

	public function up()
	{
		Schema::create('link', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('url', 1024);
			$table->string('title', 512);
			$table->text('description')->default(' ');
			$table->boolean('private')->default(false);
			$table->integer('fk_owner')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('link');
	}
}