<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('link', function(Blueprint $table) {
			$table->foreign('fk_owner')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('link_vote', function(Blueprint $table) {
			$table->foreign('fk_link_id')->references('id')->on('link')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('link_vote', function(Blueprint $table) {
			$table->foreign('fk_owner')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('link_tag', function(Blueprint $table) {
			$table->foreign('fk_link_id')->references('id')->on('link')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('link_tag', function(Blueprint $table) {
			$table->foreign('fk_tag_id')->references('id')->on('tag')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('link', function(Blueprint $table) {
			$table->dropForeign('link_fk_owner_foreign');
		});
		Schema::table('link_vote', function(Blueprint $table) {
			$table->dropForeign('link_vote_fk_link_id_foreign');
		});
		Schema::table('link_vote', function(Blueprint $table) {
			$table->dropForeign('link_vote_fk_owner_foreign');
		});
		Schema::table('link_tag', function(Blueprint $table) {
			$table->dropForeign('link_tag_fk_link_id_foreign');
		});
		Schema::table('link_tag', function(Blueprint $table) {
			$table->dropForeign('link_tag_fk_tag_id_foreign');
		});
	}
}