<?php

namespace AddresBook;

use Illuminate\Database\Eloquent\Model;

class Contact extends Model 
{

    protected $table = 'contacts';
    public $timestamps = true;

    public function groups()
    {
        return $this->belongsToMany('Group', 'group-id');
    }

    public function members()
    {
        return $this->hasMany('Contact', 'mombers');
    }

    public function appointments()
    {
        return $this->hasMany('Appointment', 'appointment-id');
    }

    public function contact()
    {
        return $this->belongsTo('Contact', 'contact-id');
    }

}