<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->string('title');
			$table->string('description');
			$table->decimal('value');
			$table->timestamps();
			$table->integer('wishlist_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}