<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'date_of_birth', 'phone', 'last_donation_date', 'password', 'pin_code', 'blood_type_id', 'city_id');

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function bloodType()
	{
		return $this->belongsTo('App\Models\BloodType');
	}

	public function donationRequests()
	{
		return $this->hasMany('App\Models\DonationRequest');
	}

	public function contacts()
	{
		return $this->hasMany('App\Models\Contact');
	}

	public function mGovernorates()
	{
		return $this->belongsToMany('App\Models\Governorate');
	}

	public function mBloodTypes()
	{
		return $this->belongsToMany('App\Models\BloodType');
	}

	public function mPosts()
	{
		return $this->belongsToMany('App\Models\Post');
	}

	public function mNotifications()
	{
		return $this->belongsToMany('App\Models\Notification');
	}

}