<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('title', 255);
			$table->text('summary')->nullable();
			$table->text('content');
			$table->string('slug', 255);
			$table->string('cover', 255);
			$table->string('video', 255)->nullable();
			$table->boolean('published')->default(1);
			$table->boolean('draft')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}