<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('role_id')->unsigned();
			$table->string('email', 50);
			$table->string('first_name', 50);
			$table->string('last_name', 50);
			$table->timestamp('birthdate');
			$table->text('description')->nullable();
			$table->string('facebook_profile', 255);
			$table->string('googleplus_profile', 255);
			$table->string('instagram_profile', 255);
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
			$table->timestamp('deleted_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}