<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMatchesTable extends Migration {

	public function up()
	{
		Schema::create('matches', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('home_team_id')->unsigned();
			$table->integer('away_team_id')->unsigned();
			$table->boolean('live')->default(0);
			$table->timestamp('start_at');
			$table->string('score')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('matches');
	}
}