<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserPermissionsTable extends Migration {

	public function up()
	{
		Schema::create('user_permissions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('role_permission_id')->unsigned();
			$table->string('is_able_to', 50)->nullable()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_permissions');
	}
}