<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMenusTable extends Migration {

	public function up()
	{
		Schema::create('menus', function(Blueprint $table) {
			$table->increments('id');
			$table->string('menu_no', 50)->index();
			$table->tinyInteger('level_no')->unsigned()->index();
			$table->boolean('level_status')->index()->default(0);
			$table->string('name_ar', 191);
			$table->string('name_en', 191);
			$table->text('desc_ar')->nullable();
			$table->text('desc_en')->nullable();
			$table->string('actions', 50)->nullable();
			$table->string('route_name', 191)->unique();
			$table->integer('parent_id')->unsigned()->nullable()->index();
			$table->integer('menu_section_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('menus');
	}
}