<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInboundShipmentsTable extends Migration {

	public function up()
	{
		Schema::create('inbound_shipments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->unsigned()->nullable();
			$table->string('tracking_id', 255)->unique()->nullable();
			$table->integer('payment_id')->unsigned()->nullable();
			$table->string('origin', 450)->nullable();
			$table->string('destination', 450)->nullable();
			$table->string('shipping_line', 450)->nullable();
			$table->string('status', 350)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('inbound_shipments');
	}
}