<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id')->unsigned()->nullable();
			$table->text('telephone')->nullable();
			$table->string('name', 75)->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->string('street', 350)->nullable();
			$table->string('postal_code', 150)->nullable();
			$table->string('city', 255)->nullable();
			$table->string('country', 255)->nullable();
			$table->string('tax_id', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('contact_person', 255)->nullable();
			$table->string('logo', 255)->nullable();
			$table->string('type', 350)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}