<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInsurancesTable extends Migration {

	public function up()
	{
		Schema::create('insurances', function(Blueprint $table) {
			$table->increments('id');
			$table->string('company_name', 255);
			$table->enum('type', array('commercial'));
			$table->string('service_phone', 25);
			$table->string('claim_phone', 25);
			$table->string('provide_link', 255);
			$table->enum('status', array('active', 'not_active'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('insurances');
	}
}