<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientInsurancesTable extends Migration {

	public function up()
	{
		Schema::create('patient_insurances', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('patient_id')->unsigned();
			$table->integer('insurance_id')->unsigned();
			$table->date('effective_day');
			$table->string('policy_holder', 50);
			$table->integer('group_id');
			$table->integer('member_id');
			$table->integer('card_id');
			$table->enum('status', array('active', 'not_active'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('patient_insurances');
	}
}