<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorInsurancesTable extends Migration {

	public function up()
	{
		Schema::create('doctor_insurances', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('doctor_id')->unsigned();
			$table->integer('insurance_id')->unsigned();
			$table->enum('status', array('active', 'inactive'));
			$table->string('updated_user_id');
			$table->string('link');
			$table->string('note', 500);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('doctor_insurances');
	}
}