<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientsTable extends Migration {

	public function up()
	{
		Schema::create('patients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 50);
			$table->string('last_name', 50);
			$table->string('email', 50);
			$table->string('cell_phone', 50);
			$table->string('home_phone', 25);
			$table->date('dob');
			$table->enum('gender', array('man', 'woman', 'other'));
			$table->string('street', 255);
			$table->string('mrn_code', 50);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('patients');
	}
}