<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->string('payment_method');
			$table->string('status');
			$table->integer('installment_id')->unsigned();
			$table->double('amount');
			$table->double('punish_of_delay')->default('0.0');
			$table->text('failure_reason')->nullable();
			$table->timestamps();
			$table->double('tax_value')->default('0.0');
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}