<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->double('financing_ratio');
			$table->double('months_financing');
			$table->double('maximum_monthly_commitments');
			$table->double('default_financier_percentage');
			$table->double('default_maximum_repayment_period');
			$table->double('efault_minimum_repayment_period');
			$table->double('default_maximum_purchase_amount');
			$table->double('default_minimum_purchase_amount');
			$table->double('interest_rate_transaction_amount');
			$table->double('maximum_amount_repaid');
			$table->double('date_of_first_installment');
			$table->double('late_fine_rate');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}