<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Field extends Model 
{

    protected $table = 'field';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'type', 'name_ar');

    public function options()
    {
        return $this->hasMany('FiledOption', 'field_id');
    }

}