<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceTable extends Migration {

	public function up()
	{
		Schema::create('invoice', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('client_id')->nullable();
			$table->string('status')->nullable();
			$table->string('payment_method')->nullable();
			$table->datetime('payment_date')->nullable();
			$table->double('amount')->nullable();
			$table->double('tax')->nullable();
			$table->double('total')->nullable();
			$table->string('number')->nullable();
			$table->string('link')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invoice');
	}
}