<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectService extends Model 
{

    protected $table = 'project_service';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('project_id', 'service_id', 'domain_id', 'server_id', 'price', 'start_at', 'end_at', 'note', 'status');

    public function project_service_fields()
    {
        return $this->hasMany('ProjectServiceField', 'project_service_id');
    }

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function domain()
    {
        return $this->belongsTo('Domain', 'domain_id');
    }

    public function server()
    {
        return $this->belongsTo('Server', 'server_id');
    }

}