<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ServiceField extends Model 
{

    protected $table = 'service_field';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('service_id', 'field_id');

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function field()
    {
        return $this->belongsTo('Field', 'field');
    }

}