<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceTable extends Migration {

	public function up()
	{
		Schema::create('service', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->boolean('active')->nullable()->default(0);
			$table->text('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('service');
	}
}