<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class HostingCompany extends Eloquent {

	protected $table = 'hosting_company';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'user_name', 'password');

	public function servers()
	{
		return $this->hasMany('Server', 'hosting_id');
	}

}