<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Domain extends Eloquent {

	protected $table = 'domain';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'user_name', 'password', 'provider_id');

	public function provider()
	{
		return $this->belongsTo('DomainProvider', 'provider_id');
	}

}