<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Server extends Eloquent {

	protected $table = 'server';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('hosting_id', 'user_name', 'password', 'link', 'ip');

	public function hosting()
	{
		return $this->belongsTo('HostingCompany', 'hosting_id');
	}

}