<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model 
{

    protected $table = 'invoice';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('client_id', 'status', 'payment_method', 'payment_date', 'amount', 'tax', 'total', 'number', 'link');

    public function client()
    {
        return $this->belongsTo('User', 'client_id');
    }

}