<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectServiceField extends Model 
{

    protected $table = 'project_service_field';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('project_service_id', 'service_field_id', 'value', 'field_id', 'service_id');

    public function field()
    {
        return $this->belongsTo('Field', 'field_id');
    }

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

}