<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchesTable extends Migration {

	public function up()
	{
		Schema::create('branches', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->string('phone');
			$table->integer('lab_id')->unsigned();
			$table->integer('area_id')->unsigned();
			$table->text('address');
			$table->string('lng');
			$table->string('lat');
		});
	}

	public function down()
	{
		Schema::drop('branches');
	}
}