<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocApplicationTable extends Migration {

	public function up()
	{
		Schema::create('doc_application', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('loan_type_id')->unsigned();
			$table->integer('document_id')->unsigned();
			$table->string('firstname');
			$table->string('lastname');
			$table->string('id_card');
			$table->date('birth_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('doc_application');
	}
}