<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstallmentPlanTable extends Migration {

	public function up()
	{
		Schema::create('Installment_Plan', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('education_level_id')->unsigned();
			$table->string('name', 50);
			$table->decimal('total_amount');
			$table->tinyInteger('number_of_installments');
			$table->tinyInteger('count_of_days_per_each_installment');
			$table->text('description')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Installment_Plan');
	}
}