<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSchoolPostTable extends Migration {

	public function up()
	{
		Schema::create('School_Post', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->text('description')->nullable();
			$table->enum('post_type', array('lesson', 'news', 'event'));
			$table->string('file_url', 500)->nullable();
			$table->boolean('is_public');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('School_Post');
	}
}