<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Student', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Student', function(Blueprint $table) {
			$table->foreign('class_id')->references('id')->on('Class_Room')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Teacher', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Teacher', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Staff_Attendance', function(Blueprint $table) {
			$table->foreign('QR_id')->references('id')->on('Qr_Codes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Staff_Attendance', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Class_Session', function(Blueprint $table) {
			$table->foreign('treacher_id')->references('id')->on('Teacher')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Class_Session', function(Blueprint $table) {
			$table->foreign('class_id')->references('id')->on('Student')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Class_Session', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Staff_leaves', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Student_Profile', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('Student')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Student_Profile', function(Blueprint $table) {
			$table->foreign('education_level_id')->references('id')->on('Education_level')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Class_Room', function(Blueprint $table) {
			$table->foreign('education_level_id')->references('id')->on('Class_Room')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Class_Teacher', function(Blueprint $table) {
			$table->foreign('class_id')->references('id')->on('Class_Room')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Class_Teacher', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('Teacher')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Supervisors', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Mark', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('Student')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Mark', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('Teacher')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Educational_Content', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('Teacher')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Educational_Content', function(Blueprint $table) {
			$table->foreign('class_id')->references('id')->on('Class_Room')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Activitie', function(Blueprint $table) {
			$table->foreign('class_id')->references('id')->on('Class_Room')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Activitie', function(Blueprint $table) {
			$table->foreign('education_level_id')->references('id')->on('Education_level')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Activity_Participant', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('Activitie')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Activity_Participant', function(Blueprint $table) {
			$table->foreign('Student_id')->references('id')->on('Student')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Book_Loan', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Book_Loan', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('Cultural_Book')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Text_Book', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Text_Book', function(Blueprint $table) {
			$table->foreign('education_level_id')->references('id')->on('Education_level')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Student_Textbook_Sale', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('Student')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Student_Textbook_Sale', function(Blueprint $table) {
			$table->foreign('textbook_id')->references('id')->on('Text_Book')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Pre_Registration', function(Blueprint $table) {
			$table->foreign('education_level_id')->references('id')->on('Education_level')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Transaction', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Installment_Plan', function(Blueprint $table) {
			$table->foreign('education_level_id')->references('id')->on('Education_level')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Installment_Payment', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('Student')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Installment_Payment', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('Installment_Plan')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Salary', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Student_attendance', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('Student')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Student_attendance', function(Blueprint $table) {
			$table->foreign('class_room_id')->references('id')->on('Student')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('Student', function(Blueprint $table) {
			$table->dropForeign('Student_user_id_foreign');
		});
		Schema::table('Student', function(Blueprint $table) {
			$table->dropForeign('Student_class_id_foreign');
		});
		Schema::table('Teacher', function(Blueprint $table) {
			$table->dropForeign('Teacher_user_id_foreign');
		});
		Schema::table('Teacher', function(Blueprint $table) {
			$table->dropForeign('Teacher_subject_id_foreign');
		});
		Schema::table('Staff_Attendance', function(Blueprint $table) {
			$table->dropForeign('Staff_Attendance_QR_id_foreign');
		});
		Schema::table('Staff_Attendance', function(Blueprint $table) {
			$table->dropForeign('Staff_Attendance_user_id_foreign');
		});
		Schema::table('Class_Session', function(Blueprint $table) {
			$table->dropForeign('Class_Session_treacher_id_foreign');
		});
		Schema::table('Class_Session', function(Blueprint $table) {
			$table->dropForeign('Class_Session_class_id_foreign');
		});
		Schema::table('Class_Session', function(Blueprint $table) {
			$table->dropForeign('Class_Session_subject_id_foreign');
		});
		Schema::table('Staff_leaves', function(Blueprint $table) {
			$table->dropForeign('Staff_leaves_user_id_foreign');
		});
		Schema::table('Student_Profile', function(Blueprint $table) {
			$table->dropForeign('Student_Profile_student_id_foreign');
		});
		Schema::table('Student_Profile', function(Blueprint $table) {
			$table->dropForeign('Student_Profile_education_level_id_foreign');
		});
		Schema::table('Class_Room', function(Blueprint $table) {
			$table->dropForeign('Class_Room_education_level_id_foreign');
		});
		Schema::table('Class_Teacher', function(Blueprint $table) {
			$table->dropForeign('Class_Teacher_class_id_foreign');
		});
		Schema::table('Class_Teacher', function(Blueprint $table) {
			$table->dropForeign('Class_Teacher_teacher_id_foreign');
		});
		Schema::table('Supervisors', function(Blueprint $table) {
			$table->dropForeign('Supervisors_user_id_foreign');
		});
		Schema::table('Mark', function(Blueprint $table) {
			$table->dropForeign('Mark_student_id_foreign');
		});
		Schema::table('Mark', function(Blueprint $table) {
			$table->dropForeign('Mark_teacher_id_foreign');
		});
		Schema::table('Educational_Content', function(Blueprint $table) {
			$table->dropForeign('Educational_Content_teacher_id_foreign');
		});
		Schema::table('Educational_Content', function(Blueprint $table) {
			$table->dropForeign('Educational_Content_class_id_foreign');
		});
		Schema::table('Activitie', function(Blueprint $table) {
			$table->dropForeign('Activitie_class_id_foreign');
		});
		Schema::table('Activitie', function(Blueprint $table) {
			$table->dropForeign('Activitie_education_level_id_foreign');
		});
		Schema::table('Activity_Participant', function(Blueprint $table) {
			$table->dropForeign('Activity_Participant_activity_id_foreign');
		});
		Schema::table('Activity_Participant', function(Blueprint $table) {
			$table->dropForeign('Activity_Participant_Student_id_foreign');
		});
		Schema::table('Book_Loan', function(Blueprint $table) {
			$table->dropForeign('Book_Loan_user_id_foreign');
		});
		Schema::table('Book_Loan', function(Blueprint $table) {
			$table->dropForeign('Book_Loan_book_id_foreign');
		});
		Schema::table('Text_Book', function(Blueprint $table) {
			$table->dropForeign('Text_Book_subject_id_foreign');
		});
		Schema::table('Text_Book', function(Blueprint $table) {
			$table->dropForeign('Text_Book_education_level_id_foreign');
		});
		Schema::table('Student_Textbook_Sale', function(Blueprint $table) {
			$table->dropForeign('Student_Textbook_Sale_student_id_foreign');
		});
		Schema::table('Student_Textbook_Sale', function(Blueprint $table) {
			$table->dropForeign('Student_Textbook_Sale_textbook_id_foreign');
		});
		Schema::table('Pre_Registration', function(Blueprint $table) {
			$table->dropForeign('Pre_Registration_education_level_id_foreign');
		});
		Schema::table('Transaction', function(Blueprint $table) {
			$table->dropForeign('Transaction_user_id_foreign');
		});
		Schema::table('Installment_Plan', function(Blueprint $table) {
			$table->dropForeign('Installment_Plan_education_level_id_foreign');
		});
		Schema::table('Installment_Payment', function(Blueprint $table) {
			$table->dropForeign('Installment_Payment_student_id_foreign');
		});
		Schema::table('Installment_Payment', function(Blueprint $table) {
			$table->dropForeign('Installment_Payment_plan_id_foreign');
		});
		Schema::table('Salary', function(Blueprint $table) {
			$table->dropForeign('Salary_user_id_foreign');
		});
		Schema::table('Student_attendance', function(Blueprint $table) {
			$table->dropForeign('Student_attendance_student_id_foreign');
		});
		Schema::table('Student_attendance', function(Blueprint $table) {
			$table->dropForeign('Student_attendance_class_room_id_foreign');
		});
	}
}