<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Education_level extends Model 
{

    protected $table = 'Education_level';
    public $timestamps = true;
    protected $fillable = array('name', 'description');
    protected $visible = array('name', 'description');

    public function students()
    {
        return $this->hasMany('Student_profile', 'education_level');
    }

    public function Regesterations()
    {
        return $this->hasMany('Pre_registration', 'education_level_id');
    }

    public function books()
    {
        return $this->hasMany('Text_book', 'education_level_id');
    }

    public function supervisor()
    {
        return $this->hasOne('\Supervisors', 'supervisor_id');
    }

}