<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'User';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'password', 'role', 'hire_date', 'ID_documents', 'phone_number', 'birth_date', 'gender', 'address', 'salary');
    protected $visible = array('name', 'email', 'password', 'role', 'hire_date', 'ID_documents', 'phone_number', 'birth_date', 'gender', 'address');

    public function leaves()
    {
        return $this->hasMany('Staff_leaves', 'user_id');
    }

    public function attendaces()
    {
        return $this->hasMany('Staff_attendance', 'user_id');
    }

    public function deductions()
    {
        return $this->hasMany('Staff_salary_deductions', 'user_id');
    }

    public function cloan_books()
    {
        return $this->hasMany('Book_loan', 'user_id');
    }

    public function salaries()
    {
        return $this->hasMany('Salary', 'user_id');
    }

    public function transactions()
    {
        return $this->hasMany('Transaction', 'user_id');
    }

}