<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeacherTable extends Migration {

	public function up()
	{
		Schema::create('Teacher', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('subject_id')->unsigned();
			$table->string('Academic_qualification', 50);
			$table->enum('Employment_status', array('active', 'suspended', 'resigned'));
			$table->enum('Payment_type', array('monthly', 'hourly'));
			$table->enum('Contract_type', array('permanent', 'temporary', 'part-time'));
			$table->date('The_beginning_of_the_contract');
			$table->date('End_of_contract');
			$table->tinyInteger('number_of_lesson_in_week');
			$table->tinyInteger('wages_per_lesson')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Teacher');
	}
}