<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Class_session extends Model 
{

    protected $table = 'Class_Session';
    public $timestamps = true;
    protected $fillable = array('treacher_id', 'class_id', 'subject_id', 'session_day', 'start_time', 'end_time');
    protected $visible = array('treacher_id', 'class_id', 'subject_id', 'session_day', 'start_time', 'end_time');

    public function subject()
    {
        return $this->belongsTo('Subject', 'subject_id');
    }

    public function class()
    {
        return $this->belongsTo('Class_room', 'class_id');
    }

    public function teacher()
    {
        return $this->belongsTo('Teacher', 'teacher_id');
    }

}