<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Student extends Model 
{

    protected $table = 'Student';
    public $timestamps = true;
    protected $fillable = array('user_id', 'Student_number', 'status');
    protected $visible = array('user_id', 'Student_number', 'status');

    public function user()
    {
        return $this->belongsTo('\User', 'user_id');
    }

    public function sessions()
    {
        return $this->hasMany('Class_session', 'student_id');
    }

    public function profile()
    {
        return $this->hasOne('Student_profile', 'student_id');
    }

    public function Activities()
    {
        return $this->hasMany('Activity_participants', 'student_id');
    }

    public function marks()
    {
        return $this->hasMany('Mark', 'student_id');
    }

    public function book_sales()
    {
        return $this->hasMany('Student_textbook_sale', 'student_id');
    }

    public function intstallments()
    {
        return $this->hasMany('Installment_payment', 'student_id');
    }

}