<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstallmentPaymentTable extends Migration {

	public function up()
	{
		Schema::create('Installment_Payment', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('student_id')->unsigned();
			$table->bigInteger('plan_id')->unsigned();
			$table->date('due_date');
			$table->decimal('amount');
			$table->boolean('paid')->default(false);
			$table->date('payment_date')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Installment_Payment');
	}
}